// // // // // // // // // // // // // // // //
//
//	AsciiKette.cc
//
//	erstellt 12.12.97 von Andreas Warnke
//	geändert 20.12.97 von Andreas Warnke
//
//	Dieses Modul stellt Funktionen zur Stringbearbeitung
//	zur Verfügung.
//
//	Die von diesem Modul bereitgestellten Funktionen
//	geben KEINE Strings, die als Argumente übergeben
//	werden frei, ABER sie reservieren Speicher für
//	die Funktionswerte.
//



#include "AsciiKette.h"



// // // // // // // // // // // // // // // //
//
//	IntToString
//	
//	konvertiert ein vorzeichenloses Integer
//	in einnen nur aus Dezimalziffern bestehenden
//	C-String.
//

char* IntToString ( unsigned int inInt )
{
	//	Eine Integer-Zahl ist höchstens 10 stellen lang.
	char* result = new char[11];;
	
	//	Speicher allokiert?
	if ( result != NULL )
	{
		int Pos;
		//	Bestimmen der StellenZahl mit binärer Suche:
		if ( inInt < 10000 )
			if ( inInt < 100 )
				if ( inInt < 10 )
					Pos = 1;
				else
					Pos = 2;
			else
				if ( inInt < 1000 )
					Pos = 3;
				else
					Pos = 4;
		else
			if ( inInt < 1e6)
				if ( inInt < 1e5 )
					Pos = 5;
				else
					Pos = 6;
			else
				if ( inInt < 1e8 )
					if ( inInt < 1e7 )
						Pos = 7;
					else
						Pos = 8;
				else
					if ( inInt < 1e9 )
						Pos = 9;
					else
						Pos = 10;
					
		//	0-terminierung:
		result[Pos] = 0;
		Pos--;
		
		//	Ziffern:
		do
		{
			result[Pos] = ( inInt ) % 10 + 48;
			inInt = ( inInt ) / 10;
			Pos--;
		}
		while ( Pos >= 0 );
	};
	
	//	Fertig:
	return result;
};

char* Int8ToHexString ( uint8 inInt8 )
{
	char* res = new char[5];
	if ( res != NULL )
	{
		res[0]='0';
		res[1]='x';
		res[2]= inInt8 >= 0xa0 ? ( inInt8 >> 4 ) + 87 : ( inInt8 >> 4 ) + 48;
		res[3]= ( inInt8 & 0x0f ) >= 0x0a ? ( inInt8 & 0x0f ) + 87 : ( inInt8 & 0x0f ) + 48;
		res[4]=0;
	};
	return res;
};



// // // // // // // // // // // // // // // //
//
//	StringToInt
//	
//	konvertiert einen C-String in ein Integer.
//	Alle Zeichen außer Dezimalziffern werden
//	ignoriert. Ist keine Ziffer vorhanden, so
//	liefert StringToInt 0. Ist das Argument
//	ein NULL-Pointer, so liefert die Funktion
//	ebenfalls 0.
//

unsigned int StringToInt ( const char* inString )
{
	unsigned int result = 0;
	
	//	gültiger inString?
	if ( inString != NULL )
	{
		int Pos = 0;
		
		//	solange das Ende des Strings noch nicht erreicht ist:
		while ( inString[Pos] != 0 )
		{
			//	ist inString[Pos] eine Dezimalziffer?
			if (( inString[Pos] >= 48 ) && ( inString[Pos] < 58 ))
			{
				result = result * 10 + inString[Pos] - 48;
			};
			
			//	Naechstes Zeichen: 
			Pos++;
		};
	};
	
	//	Fertig:
	return result;
};



// // // // // // // // // // // // // // // //
//
//	GetPos
//	
//	liefert die Position eines Musters in einem
//	String. Die Numerierung der Zeichen beginnt
//	mit 0. Ist eines der Funktionsargumente NULL,
//	oder das Muster nicht im String enthalten,
//	so liefert GetPos 0xfff..f .
//

unsigned int GetPos ( const char* inMuster, const char* inString, unsigned int inBeginAt )
{
	//	Fehler bei Parametern:
	if (( inMuster == NULL ) || ( inString == NULL ))
		return -1;
		
	//	Mustersuche:
	unsigned int check = inBeginAt;
	unsigned int match = 0;
	
	//	Durchlauf String:
	while ( ( inString[check] != 0 ) && ( inMuster[match] != 0 ))
	{
		if ( inString[check+match] == inMuster[match] )
			match++;
		else
		{
			match = 0;
			check++;
		};
	};
	
	//	Fertig:
	if ( inMuster[match] == 0 )
		return check;
	else
		return -1;
};



// // // // // // // // // // // // // // // //
//
//	Length
//
//	Bestimmt die Länge eines Strings in Bytes.
//	Der 0-Terminator wird nicht mitgezählt. Ist
//	der übergebene String NULL, so wird 0 berechnet.
//	

unsigned int Length ( const char* inString )
{
	unsigned int result = 0;
	
	//	gültige eingabe?
	if ( inString != NULL )
		//	Zähle:
		while ( inString[result] != 0 )
			result++;
			
	//	Fertig:
	return result;
};



// // // // // // // // // // // // // // // //
//
//	Concat
//	
//	Fügt die als Parameter übergebenen Strings
//	zusammen. Ist einer der Parameter NULL, so
//	wird er ignoriert. Sind alle Parameter null, 
//	so ist das Ergebis ein Zeiger auf ein 0-character.
//

char* Concat (
	const char* inString1,
	const char* inString2,
	const char* inString3,
	const char* inString4 )
{
	char* result;
	unsigned int NewLength;
	
	//	Allokiere nötigen Speicher:
	NewLength =
		Length (inString1)
		+ Length (inString2)
		+ Length (inString3)
		+ Length (inString4);
	result = new char[NewLength+1];
	
	//	Speicher reserviert?
	if ( result != NULL )
	{
		unsigned int OldPos;
		unsigned int NewPos = 0;
		
		//	Kopiere, bis NewPos == NewLength
		OldPos = 0;
		if ( inString1 != NULL ) 
			while ( inString1[OldPos] != 0 )
				result[NewPos++] = inString1[OldPos++];
		OldPos = 0;
		if ( inString2 != NULL ) 
			while ( inString2[OldPos] != 0 )
				result[NewPos++] = inString2[OldPos++];
		OldPos = 0;
		if ( inString3 != NULL ) 
			while ( inString3[OldPos] != 0 )
				result[NewPos++] = inString3[OldPos++];
		OldPos = 0;
		if ( inString4 != NULL ) 
			while ( inString4[OldPos] != 0 )
				result[NewPos++] = inString4[OldPos++];
				
		//	0-Terminator:
		result[NewPos] = 0;
	};
	
	return result;
};



// // // // // // // // // // // // // // // //
//
//	Equal
//	
//	Prüft, of die beiden übergebenen Strings
//	identisch sind. Sind einer oder beide Parameter
//	NULL, so liefert Equal false.

bool Equal ( const char* inString1, const char* inString2 )
{
	//	NULL?
	if ( ( inString1 == NULL ) || ( inString2 == NULL ) )
		return false;
		
	//	Prüfe, bis 0-character:
	unsigned int Pos = 0;
	while ( inString1 [Pos] != 0 ) 	
	{
		if ( inString1 [Pos] != inString2 [Pos] )
			return false;
		Pos++;
	};
	
	//	Fertig:
	return ( inString1 [Pos] == inString2 [Pos] );
};



// // // // // // // // // // // // // // // //
//
//	ConcatAndDeleteEven/Odd
//	
//	Fügt die als Parameter übergebenen Strings
//	zusammen. Ist einer der Parameter NULL, so
//	wird er ignoriert. Sind alle Parameter null, 
//	so ist das Ergebis ein Zeiger auf ein 0-character.
//	Die als 2. und 4. bzw. 1. und 3. Parameter
//	übergebenen Strings werden mit delete[] gelöscht.
//

char* ConcatAndDeleteEven ( 
	const char* inString1,
	char* inString2,
	const char* inString3,
	char* inString4)
{
	char * sErg = Concat ( inString1, inString2, inString3, inString4 );
	if ( inString2 != NULL )
		delete [] inString2;
	if ( inString4 != NULL )
		delete [] inString4;
	return sErg;
};

char* ConcatAndDeleteOdd ( 
	char* inString1,
	const char* inString2,
	char* inString3,
	const char* inString4)
{
	char * sErg = Concat ( inString1, inString2, inString3, inString4 );
	if ( inString1 != NULL )
		delete [] inString1;
	if ( inString3 != NULL )
		delete [] inString3;
	return sErg;
};



//
//	The End
//
// // // // // // // // // // // // // // // //
